<?php
require_once 'config.php';

if(!isLoggedIn()) {
    header("Location: login.php");
    exit();
}

if(isActiveUser()) {
    header("Location: dashboard.php");
    exit();
}

$settings = getSettings();
$activation_fee = $settings['activation_fee'];
$user_balance = getUserBalance($_SESSION['user_id']);

$error = '';
$success = '';

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    if($user_balance >= $activation_fee) {
        // Start transaction
        $conn->begin_transaction();
        
        try {
            // Update user to active
            $conn->query("UPDATE users SET is_active = TRUE, balance = balance - $activation_fee WHERE id = {$_SESSION['user_id']}");
            
            // Record transaction
            $conn->query("INSERT INTO transactions (user_id, type, amount, description, status) 
                         VALUES ({$_SESSION['user_id']}, 'activation', $activation_fee, 'Account activation fee', 'completed')");
            
            // Check if user was referred
            $referral_check = $conn->query("SELECT referrer_id FROM referrals WHERE referred_id = {$_SESSION['user_id']} AND status = 'pending'");
            if($referral_check->num_rows > 0) {
                $referral = $referral_check->fetch_assoc();
                $referrer_id = $referral['referrer_id'];
                $referral_bonus = $activation_fee * ($settings['referral_percentage'] / 100);
                
                // Update referrer balance
                $conn->query("UPDATE users SET balance = balance + $referral_bonus WHERE id = $referrer_id");
                
                // Record referral bonus transaction
                $conn->query("INSERT INTO transactions (user_id, type, amount, description, status) 
                             VALUES ($referrer_id, 'referral_bonus', $referral_bonus, 'Referral bonus from user activation', 'completed')");
                
                // Update referral status
                $conn->query("UPDATE referrals SET bonus_amount = $referral_bonus, status = 'paid' WHERE referred_id = {$_SESSION['user_id']}");
            }
            
            $conn->commit();
            
            // Update session
            $_SESSION['is_active'] = true;
            
            $success = "Account activated successfully! Redirecting to dashboard...";
            header("refresh:2;url=dashboard.php");
        } catch (Exception $e) {
            $conn->rollback();
            $error = "Activation failed. Please try again.";
        }
    } else {
        $error = "Insufficient balance. Please deposit at least ৳$activation_fee";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Activate Account - Project Sale</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        .card-hover {
            transition: all 0.3s ease;
        }
        .card-hover:hover {
            transform: translateY(-10px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body class="bg-gradient-to-br from-blue-50 to-indigo-100 min-h-screen">
    <!-- Navigation -->
    <nav class="bg-white shadow-sm">
        <div class="container mx-auto px-6 py-4">
            <a href="index.php" class="text-2xl font-bold text-blue-600">
                <i class="fas fa-rocket mr-2"></i>ProjectSale
            </a>
        </div>
    </nav>
    
    <div class="container mx-auto px-4 py-12">
        <div class="max-w-4xl mx-auto">
            <!-- Progress Steps -->
            <div class="flex justify-between items-center mb-12 relative">
                <div class="absolute top-1/2 left-0 right-0 h-1 bg-gray-200 -z-10"></div>
                
                <div class="flex flex-col items-center relative">
                    <div class="w-12 h-12 rounded-full bg-green-500 flex items-center justify-center text-white font-bold">
                        1
                    </div>
                    <span class="mt-2 text-sm font-medium text-green-600">Registration</span>
                </div>
                
                <div class="flex flex-col items-center relative">
                    <div class="w-12 h-12 rounded-full bg-blue-500 flex items-center justify-center text-white font-bold">
                        2
                    </div>
                    <span class="mt-2 text-sm font-medium text-blue-600">Activation</span>
                </div>
                
                <div class="flex flex-col items-center relative">
                    <div class="w-12 h-12 rounded-full bg-gray-300 flex items-center justify-center text-gray-500 font-bold">
                        3
                    </div>
                    <span class="mt-2 text-sm font-medium text-gray-500">Dashboard</span>
                </div>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
                <!-- Activation Card -->
                <div class="bg-white rounded-2xl shadow-xl p-8 card-hover">
                    <div class="text-center mb-8">
                        <div class="w-24 h-24 bg-blue-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-bolt text-blue-500 text-4xl"></i>
                        </div>
                        <h1 class="text-3xl font-bold text-gray-800 mb-3">Activate Your Account</h1>
                        <p class="text-gray-600">Unlock all features and start earning</p>
                    </div>
                    
                    <?php if($error): ?>
                        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-exclamation-circle text-red-500 mr-3 text-xl"></i>
                                <span class="text-red-700"><?php echo $error; ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <?php if($success): ?>
                        <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
                            <div class="flex items-center">
                                <i class="fas fa-check-circle text-green-500 mr-3 text-xl"></i>
                                <span class="text-green-700"><?php echo $success; ?></span>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="bg-blue-50 rounded-xl p-6 mb-8">
                        <div class="flex justify-between items-center mb-4">
                            <span class="text-lg font-semibold text-gray-700">Activation Fee:</span>
                            <span class="text-3xl font-bold text-blue-600">৳<?php echo $activation_fee; ?></span>
                        </div>
                        
                        <div class="flex justify-between items-center">
                            <span class="text-gray-600">Your Balance:</span>
                            <span class="text-2xl font-bold <?php echo $user_balance >= $activation_fee ? 'text-green-600' : 'text-red-600'; ?>">
                                ৳<?php echo number_format($user_balance, 2); ?>
                            </span>
                        </div>
                        
                        <?php if($user_balance < $activation_fee): ?>
                            <div class="mt-4 p-3 bg-yellow-50 border border-yellow-200 rounded-lg">
                                <p class="text-yellow-700 text-sm">
                                    <i class="fas fa-exclamation-triangle mr-2"></i>
                                    You need ৳<?php echo number_format($activation_fee - $user_balance, 2); ?> more to activate
                                </p>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <form method="POST" action="">
                        <?php if($user_balance >= $activation_fee): ?>
                            <button type="submit"
                                    class="w-full bg-gradient-to-r from-green-500 to-emerald-600 text-white font-bold py-4 px-6 rounded-xl text-lg hover:from-green-600 hover:to-emerald-700 focus:outline-none focus:ring-2 focus:ring-green-500 focus:ring-offset-2 transition duration-300 transform hover:scale-105">
                                <i class="fas fa-bolt mr-2"></i> Activate Now
                            </button>
                        <?php else: ?>
                            <a href="deposit.php"
                               class="block w-full text-center bg-gradient-to-r from-blue-500 to-indigo-600 text-white font-bold py-4 px-6 rounded-xl text-lg hover:from-blue-600 hover:to-indigo-700 focus:outline-none focus:ring-2 focus:ring-blue-500 focus:ring-offset-2 transition duration-300 transform hover:scale-105">
                                <i class="fas fa-plus-circle mr-2"></i> Deposit Now
                            </a>
                        <?php endif; ?>
                    </form>
                    
                    <div class="mt-6 text-center">
                        <p class="text-gray-500 text-sm">
                            After activation, you'll get access to all products and features
                        </p>
                    </div>
                </div>
                
                <!-- Benefits Card -->
                <div class="space-y-6">
                    <div class="bg-gradient-to-r from-purple-500 to-pink-500 rounded-2xl shadow-xl p-8 text-white card-hover">
                        <h2 class="text-2xl font-bold mb-6">💎 Premium Benefits</h2>
                        <ul class="space-y-4">
                            <li class="flex items-center">
                                <i class="fas fa-check-circle mr-3 text-xl"></i>
                                <span>Access to all premium products</span>
                            </li>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle mr-3 text-xl"></i>
                                <span>Start earning from referrals</span>
                            </li>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle mr-3 text-xl"></i>
                                <span>Direct support priority</span>
                            </li>
                            <li class="flex items-center">
                                <i class="fas fa-check-circle mr-3 text-xl"></i>
                                <span>Exclusive deals and discounts</span>
                            </li>
                        </ul>
                    </div>
                    
                    <div class="bg-white rounded-2xl shadow-xl p-8 card-hover">
                        <h2 class="text-2xl font-bold text-gray-800 mb-6">💰 Referral System</h2>
                        <div class="bg-gray-50 rounded-xl p-6">
                            <div class="text-center mb-6">
                                <div class="text-5xl font-bold text-blue-600"><?php echo $settings['referral_percentage']; ?>%</div>
                                <p class="text-gray-600 mt-2">Commission on referrals</p>
                            </div>
                            
                            <div class="space-y-4">
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-blue-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-user-plus text-blue-600"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-800">Step 1: Share Your Link</h4>
                                        <p class="text-gray-600 text-sm">Share your unique referral link</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-green-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-user-check text-green-600"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-800">Step 2: They Activate</h4>
                                        <p class="text-gray-600 text-sm">Referred user activates account</p>
                                    </div>
                                </div>
                                
                                <div class="flex items-center">
                                    <div class="w-10 h-10 bg-yellow-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-money-bill-wave text-yellow-600"></i>
                                    </div>
                                    <div>
                                        <h4 class="font-semibold text-gray-800">Step 3: Earn Commission</h4>
                                        <p class="text-gray-600 text-sm">Get <?php echo $settings['referral_percentage']; ?>% instantly</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Add animation to cards
            const cards = document.querySelectorAll('.card-hover');
            cards.forEach((card, index) => {
                card.style.animationDelay = `${index * 0.2}s`;
                card.classList.add('animate__animated', 'animate__fadeInUp');
            });
        });
    </script>
</body>
</html>